<?php
/**
 * 短信宝发送短信接口
 * Author: SuiFeng 87211061@qq.com
 * Copyright (c) 2017-2020 http://www.qibo168.com All rights reserved.
 * Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
 * Date: 2017/11/29
 */

namespace plugins\smsbao;

class Api{
	private $accessKeyId;
	private $accessKeySecret;
	function __construct($accessKeyId, $accessKeySecret) {
		$this->accessKeyId = $accessKeyId;
		$this->accessKeySecret = $accessKeySecret;
	}
	/**
	 * 发送短信
	 *
	 * @param string $signName 必填, 短信签名
	 * @param string $templateCode 必填, 短信模板Code
	 * @param string $phoneNumbers 必填, 短信接收号码
	 */
	public function sendSms($signName, $templateCode, $phoneNumbers, $templateParam = null) {

		$key = array_keys($templateParam);
		$value = array_values($templateParam);
		$content =  str_replace($key,$value,$templateCode);
		$url = "http://api.smsbao.com/sms?u=".$this->accessKeyId.'&p='.md5($this->accessKeySecret).'&m='.$phoneNumbers.'&c=【'.$signName.'】'.$content;
		return $this->http($url);
	}


	/**
     * 通用CURL请求
     * @param $url  需要请求的url
     * @param null $data
     * return mixed 返回值 json格式的数据
     */
	private function http($url,$data=null)
	{
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        if (!empty($data)) {
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        }
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $info = curl_exec($curl);
        curl_close($curl);
        return $info;
	}

}